
//============================================================================
//----------------------------------------------------------------------------
//								VisFramework.h
//								version 1.0.0
//								Mike Wright
//								darwin@mbay.net
//
//	Header file for the Visual Framework Plug-in module.
//
//----------------------------------------------------------------------------
//============================================================================


#pragma once


#ifndef DEBUGLEVEL
#define DEBUGLEVEL	DEBUGON
#endif

#include "SoundJamAPI.h"
#include "VisualPlugin.h"


/*==================================================================================================
									Defines
==================================================================================================*/


/* visual framework plugin drawing modes */
/*
enum
{	kLetterMode		= 1,
	kLineMode		= 2,
	kBoxMode		= 3,
	kTwoColorMode	= 4,
	kMultiColorMode	= 5
};*/

/*==================================================================================================
									Typedefs
==================================================================================================*/

/*======================================================================*/
/* This is the struct that contains the global data that is stored in	*/
/* the refcon, restored in VisHandler(), and passed by VisHandler() to  */
/* the handler  routines as *plugInData.								*/
/*																		*/
/* For purposes of the framework, fields have been included that match	*/
/* most fields of the various structs associated with the various 		*/
/* messages. They are filled in by the handler routines for those 		*/
/* messages.															*/
/*																		*/
/* You may remove any of these fields that your plugin does not use.	*/
/*																		*/
/* There are also fields that are specific to the internal operation	*/
/* of the plugin module. These will change, depending on the needs of	*/
/* your plugin.														*/
/*======================================================================*/

class WhiteCap;

struct VisHandlerData
{
	/* VisualPluginInitMessage data*/
	void				*appCookie;
	SoundJamProcPtr		playerProc;
	UInt32				version;
	
	/* VisualPluginShowWindowMessage data */
	CGrafPtr			port;
	Rect				drawRect;
	
	/* VisualPluginPlayMessage data */
	TrackSpec			*trackSpec;
	SInt32				volume;
	UInt32				bitRate;
	SoundComponentData	soundFormat;
	
	/* VisualPluginRenderMessage data */
	RenderVisualData	renderData;

	/* VisualPluginProcessSamplesMessage */
	UInt32				timeStampID;
	SInt16				*sampleBuffer;		/* the data in this buffer may be modified by the plugin	*/
	UInt32				numSamples;
	UInt32				maxSamples;
	UInt32				numOutputSamples;	/* must be less than or equal to maxSamples 				*/
	
	/* framework-specific data */
	OSType				magic;				/* used to identify our plugin for debugging purposes		*/
	Boolean				visEnabled;			/* is it okay to draw to the module window?					*/
	UInt8				drawMode;			/* kLetterMode, kLineMode, and kBoxMode are possible values	*/
	UInt8				colorMode;			/* kTwoColorMode and kMultiColorMode are possible values	*/
	SInt16				LRcolor;			/* one of the eight basic QuickDraw color values			*/
	SInt16				RLcolor;			/* one of the eight basic QuickDraw color values			*/

	float				mSample[ NUM_SAMPLE_BINS ];
	WhiteCap*			mWC;
};
typedef struct VisHandlerData VisHandlerData;


/*======================================================================*/
/* In our HandleCancelMessage() function, we set these fields to their	*/
/* equivalents in VisHandlerData. Then we use the PlayerSetPluginData()	*/
/* function to send this struct to SoundJam.							*/
/* In our HandleInitializeMessage() function, we retrieve it from 		*/
/* SoundJam using the PlayerSetPluginData() function.					*/
/* 																		*/
/* You can modify this struct to save any preferences that you choose.	*/
/*======================================================================*/
struct VisPluginPrefs
{
	UInt8				drawMode;			/* kLetterMode, kLineMode, and kBoxMode are possible values	*/
	UInt8				colorMode;			/* kTwoColorMode and kMultiColorMode are possible values	*/
	SInt16				LRcolor;			/* one of the eight basic QuickDraw color values			*/
	SInt16				RLcolor;			/* one of the eight basic QuickDraw color values			*/	
};
typedef struct VisPluginPrefs 	VisPluginPrefs; 

/*==================================================================================================
									Function Prototypes
==================================================================================================*/

/* functions in VisFrameworkMain.c */
OSStatus main (OSType message, PluginMessageInfo *messageInfo, void *refcon);
OSStatus VisHandler (OSType message, VisualPluginMessageInfo *messageInfo, void *refcon);

/* functions in VisFrameworkHandlers.c */
OSStatus HandleInitializeMessage (VisualPluginMessageInfo *messageInfo, VisHandlerData *plugInData);
OSStatus HandleCleanupMessage (VisHandlerData *plugInData);
OSStatus HandleEnableMessage (VisHandlerData *plugInData);
OSStatus HandleDisableMessage (VisHandlerData *plugInData);
OSStatus HandleShowWindowMessage (VisualPluginMessageInfo *messageInfo, VisHandlerData *plugInData);
OSStatus HandleSetWindowMessage (VisualPluginMessageInfo *messageInfo, VisHandlerData *plugInData);
OSStatus HandleHideWindowMessage (VisHandlerData *plugInData);
OSStatus HandleResizeMessage (VisualPluginMessageInfo *messageInfo, VisHandlerData *plugInData);
OSStatus HandlePlayMessage (VisualPluginMessageInfo *messageInfo, VisHandlerData *plugInData);
OSStatus HandleStopMessage (VisHandlerData *plugInData);
OSStatus HandlePauseMessage (VisHandlerData *plugInData);
OSStatus HandleUnpauseMessage (VisHandlerData *plugInData);
OSStatus HandleRenderMessage (VisualPluginMessageInfo *messageInfo, VisHandlerData *plugInData);
OSStatus HandleProcessSamplesMessage (VisualPluginMessageInfo *messageInfo, VisHandlerData *plugInData);
OSStatus HandleFlushSamplesMessage (VisHandlerData *plugInData);
OSStatus HandleEventMessage (VisualPluginMessageInfo *messageInfo, VisHandlerData *plugInData);
OSStatus HandleUpdateMessage (VisHandlerData *plugInData);
OSStatus HandleIdleMessage (VisHandlerData *plugInData);


void HandlePlugInMouseDown (VisHandlerData *plugInData, EventRecord *theEvent);
